--------------------------------------------------------------------------------
-- MapName: Beispielkarte
--
-- Author: Mapping-Wiki
--
--------------------------------------------------------------------------------

-- Include main function
Script.Load( Folders.MapTools.."Main.lua" )
IncludeGlobals("MapEditorTools")

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called from main script to initialize the diplomacy states
function InitDiplomacy()
    SetHostile(1, 2)
    SetPlayerName(2, "Kerberos")
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called from main script to init all resources for player(s)
function InitResources()
    AddGold(1, 500)
    AddClay(1, 1200)
    AddWood(1, 1500)
    AddStone(1, 800)
    AddIron(1, 400)
    AddSulfur(1, 250)
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called to setup Technology states on mission start
function InitTechnologies()
    ForbidTechnology(Technologies.UP2_Tower, 1)
    ResearchTechnology(Technologies.GT_Construction, 1)

    ResearchTechnology(Technologies.T_ChainMailArmor, 2) -- Kettenhemd
    ResearchTechnology(Technologies.T_LeatherMailArmor, 2) -- Kettenlederrüstung
    ResearchTechnology(Technologies.T_PlateMailArmor, 2) -- Plattenharnisch
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start and after save game is loaded, setup your weather gfx
-- sets here
function InitWeatherGfxSets()
    SetupNormalWeatherGfxSet()
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start you should setup your weather periods here
function InitWeather()
    -- Eine komfortable Schreibweise für Wetterelemente ist Anzahl der Minuten x Sekunden pro Minute
    -- So wird das Skript leserlicher und die Rechnerei entfällt bzw. wird dem Computer überlassen
    -- In dem Fall haben wir 10 Minuten Sommer und 2 Minuten Regen
    AddPeriodicSummer(10 * 60)
    AddPeriodicRain(2 * 60)
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start and after save game to initialize player colors
function InitPlayerColorMapping()
    Display.SetPlayerColorMapping(2, KERBEROS_COLOR)
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start after all initialization is done
function FirstMapAction()
    CreatePlayer2()
    CreateBriefingIntro()
end

function CreatePlayer2()
    --- Wir beginnen mit MapEditor_SetupAI
 
    --- Die Spieler-Id ist 2, da die Gebäude, die wir auf der Karte platziert haben, Spieler 2 gehören
 
    --- Für die Stärke wählen wir einen Wert von 2. Das hat den Grund, dass wir zum einen dem Spieler
    --  den Ausbau zu Kanonentürmen verboten haben und zum anderen nur 3 Siedlungsplätze zur 
    --  Verfügung stellen. Rechnerisch wir die KI bei Stärke 2 32 Hauptmänner auf einmal befehligen.
    --  Der Spieler soll die Kapazitäten haben, sich dagegen zu verteidigen und auch angreifen zu können
 
    --- Da der Gegner von Wasser vom Spieler abgetrennt ist und der Spieler allein entscheidet, wann
    --  es zu einem Kampf kommt, kann der Radius der Größe der Karte entsprechen. Die Karte hat die
    --  Größe 320, also tragen wir als Radius 32000 ein
 
    --- Beim Techlevel tragen wir 3 ein, da der Spieler beliebig viel Zeit hat, sich vorzubereiten. Da
    --  ein Angriff die Wettertechnologien voraussetzt, muss er außerdem zwangsläufig schon weit im
    --  Forschungsbaum fortgeschritten sein. Der KI-Gegner soll dann immer noch eine Herausforderung sein
 
    --- Die Position ist die von uns gesetzte und benannte Burg des Gegners "Player2"
 
    --- Bei der Aggressivität wählen wir ebenfalls 2, sodass die KI mit der Hälfte ihrer Truppen angreifen kann
 
    --- Eine Friedenszeit brauchen wir nicht einzustellen, da der Spieler selbst entscheidet, wann der
    --  Kampf beginnt, also lassen wir diesen Parameter auf 0
 
    --- Insgesamt haben wir also:
    MapEditor_SetupAI(2, 2, 32000, 3, "Player2", 2, 0)
 
    --- Wir erstellen nun ein Table, das die Einstellungen für SetupPlayerAi enthält
    local AiDescription = {
        -- Wir machen folgende Verteilung: Ressourcen, die für den (Wieder-) Aufbau von Gebäuden gebraucht 
        -- werden, sollen ausreichend zur Verfügung stehen
        -- Ressourcen, die für die Rekrutierung der Armeen notwendig sind, sollen regelmäßig, aber nicht
        -- zu üppig an die KI gehen, damit sie zwar längere Gefechte austragen, aber auf lange Sicht nicht 
        -- beliebig viele Truppen ausheben kann
        resources = {
            gold = 4500,
            clay = 10000,
            iron = 3000,
            sulfur = 1500,
            stone = 15000,
            wood = 12000
        },
        -- Die KI erhält alle 2 Minuten 1500 Taler, 1000 Eisen und 700 Schwefel, solange diese Ressourcen
        -- unterhalb des angegebenen Maximums liegen
        refresh = {
            gold = 1500,
            clay = 0,
            iron = 1000,
            sulfur = 700,
            stone = 0,
            wood = 0,
            updateTime = 120
        },
        -- Beim Limit für Leibeigene entscheiden wir uns für 6, da die KI keine Ressourcen abzubauen braucht.
        -- Die Leibeigenen sollen also allein zerstörte Gebäude reparieren bzw. wieder aufbauen. Damit der
        -- Spieler in seinem Fortschritt nicht zu sehr gebremst wird, sollte diese Zahl nicht zu hoch sein,
        -- da er andernfalls viel Zeit damit verbringen wird, feindlichen Leibeigenen hinterher zu jagen 
        serfLimit = 6,
        -- Leibeigene sollen keine Ressourcen abbauen. Dadurch entgehen wir auch dem Bug, bei dem das Spiel
        -- stark zu ruckeln beginnt, wenn Leibeigene keinen Zugang zu Ressourcen mehr haben
        extracting = 0,
        -- Wenn Leibeigene keine Ressourcen abbauen, brauchen sie sich auch auf keinen Ressourcentyp zu 
        -- fokussieren
        resourceFocus = nil,
        -- Beschädigte Gebäude sollen repariert werden
        repairing = true,
        -- Zerstörte Gebäude sollen nach genau 90 Sekunden wieder aufgebaut werden, also ohne zufällige
        -- Zeitkomponente
        rebuild = {
            delay = 90,
            randomTime = 0
        },
        -- Damit der Wiederaufbau funktioniert, muss es der KI erlaubt sein, Gebäude zu errichten
        constructing = true
    }
    SetupPlayerAi(2, AiDescription)
end

function CreateBriefingIntro()
    local Briefing = {
        -- Seite 1, ein Table im Table
        {
            -- Mit dem Schlüssel title wird der Titel der Briefingseite angegeben
            title = "Mentor",
            -- Mit dem Schlüssel text wird der Text der Briefingseite angegeben
            text = "Kerberos hat sich auf der anderen Seite des Flusses festgesetzt.",
            -- Mit dem Schlüssel position wird die Position der Briefingseite angegeben
            -- Die Funktion GetPosition nimmt den Namen einer Entity als Parameter und
            -- gibt ihre Postion zurück. Da wir beim Erstellen der Karte ein XD_ScriptEntity
            -- mit dem Namen "PositionCampfire" platziert haben, können wir die Kamera nun
            -- genau auf diese Position richten.
            position = GetPosition("PositionCampfire"),
            -- Mit dem Schlüssel dialogCamera kann optional eine alternative Zoomstufe
            -- eingenommen werden, bei der die Kamera näher am Boden ist. Bei der Position
            -- um das Lagerfeuer sind hauptsächlich die Helden zu sehen, sodass sie mit
            -- dieser Option besser ins Bild gerückt werden.
            dialogCamera = true
        },

        -- Seite 2, ein weiteres Table. Wichtig: Komma nicht vergessen!
        {
            title = "Mentor",
            text = "Im Moment ist seine Befestigung hoch oben auf dem Berg für Euch unerreichbar.",
            -- Die Position der Kamera soll nun die des gegnerischen Hauptquartiers sein
            position = GetPosition("Player2"),
            -- Da die Position des Gegners noch verdeckt ist, würde man auf dieser Seite nur
            -- schwarze Landschaft sehen, würde man sie nicht aufdecken.
            -- Mit dem Schlüssel explore kann die Landschaft um die gegebene Position
            -- aufgedeckt werden. Dazu muss ein Radius angegeben werden, der definiert,
            -- wie groß das aufgedeckte Gebiet sein soll
            explore = 1000
        },

        -- Seite 3
        {
            title = "Mentor",
            text = "Ihr müsst einen Weg finden, Euch seiner Burg zu nähern.",
            position = GetPosition("Player2"),
            -- Mit dem Schlüssel marker können wir eine Markierung auf der Minimap
            -- erstellen. Mit ANIMATED_MARKER pulsiert diese Markierung auffällig,
            -- während STATIC_MARKER eine statische Markierung an die Position
            -- setzt
            marker = ANIMATED_MARKER
        },

        -- Seite 4
        {
            title = "Mentor",
            text = "Möglicherweise schafft Ihr es, im Winter über das Wasser zu gelangen. "..
                "Achtet jedoch darauf, Eure Burg nicht zu verlieren!",
            position = GetPosition("Player1")
        },

        -- An dieser Stelle sind die Seiten des Briefings komplett beschrieben. Wir wollen
        -- aber noch einige Optionen für das Briefing setzen
        -- finished erlaubt uns, eine Funktion anzugeben, die unmittelbar nach dem Ende des
        -- Briefings aufgerufen wird.
        -- Diese Funktion müssen wir später natürlich noch definieren
        finished = BriefingIntroFinished,
        -- Mit restoreCamera können wir angeben, ob die Kamera nach dem Briefing auf die
        -- Position zurückspringen soll, an der sie vor Beginn des Briefings war oder aber
        -- an der Position der letzten Briefingseite verbleiben soll.
        -- Weil die Kamera zu Beginn einer Karte auf die Mitte der Karte zeigt, ist es schöner,
        -- wenn sie zum Schluss auf das Hauptquartier des Spielers zeigt
        restoreCamera = false
    }

    -- Auf Seite 2 haben wir einen Teil der Landschaft aufgedeckt. Damit wir ihn nach dem Briefing
    -- wieder verdecken können, müssen wir uns die Briefingseite merken, in der wir aufgedeckt haben.
    -- Dazu speichern wir die ganze Seite in einer globalen Variable
    BriefingIntroExplore = Briefing[2]

    -- Jetzt können wir das Briefing starten
    StartBriefing(Briefing)
end

function BriefingIntroFinished()
    -- Die Briefing-Seite, die wir uns zuvor gemerkt haben, kann mit ResolveBriefing 
    -- "rückgängig" gemacht werden. Auf die gleiche Art und Weise kann auch ein Marker
    -- wieder von der Minimap entfernt werden.
    ResolveBriefing(BriefingIntroExplore)

    -- Mit Logic.AddQuest kann eine neue Quest im Auftragsmenü erstellt werden bzw.
    -- eine vorhandene verändert. In Ebene 2 werden wir genauer darauf eingehen.
    -- Parameter 1 ist die Spieler-Id, muss für den menschlichen Spieler also 1 sein
    -- Parameter 2 ist die Quest-Id und ist eine ganze Zahl >= 1. Beachte, dass
    -- das Spiel nicht mehr als 8 Quests gleichzeitig darstellen kann. Wenn mehrere
    -- Quests ins Spiel kommen, ist es sinnvoll, den Quest-Ids über Variablen Namen
    -- zu geben, um eine bessere Übersicht zu wahren
    -- Parameter 3 ist der Questtyp. Zur Auswahl stehen MAINQUEST_OPEN, MAINQUEST_CLOSED, 
    -- SUBQUEST_OPEN und SUBQUEST_CLOSED. Da unsere Quest eine offene Hauptaufgabe
    -- ist, wählen wir MAINQUEST_OPEN
    -- Parameter 4 ist der Titel der Quest
    -- Parameter 5 ist der Text der Quest
    -- Parameter 6 ist entweder 0 oder 1 und gibt an, ob der Mentor auf die neue
    -- Aufgabe aufmerksam machen soll.
    QuestDefeatKerberos = 1
    Logic.AddQuest(1, QuestDefeatKerberos, MAINQUEST_OPEN, "Besiegt Kerberos", "Auf der "..
        "anderen Seite des Flusses hat Kerberos einen Stützpunkt errichtet. Findet einen "..
        "Weg über den Fluss und stellt ihn in seiner Burg!", 1)
end